<?php
include_once 'db.php';

// Enable error reporting for debugging
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Retrieve POST data with defaults if not set
$productid = $_POST["productid"] ?? [];
$mrp = $_POST["mrp"] ?? [];
$qty = $_POST["qty"] ?? [];
$price = $_POST["price"] ?? [];
$discountvalue = $_POST["discountvalue"] ?? [];
$discountpercentage = $_POST["discountpercentage"] ?? [];
$taxvalue = $_POST["taxvalue"] ?? [];
$taxpercentage = $_POST["taxpercentage"] ?? [];
$customerid = $_POST["customerid"] ?? '';
$invoicedate = $_POST["invoicedate"] ?? '';
$duedate = $_POST["duedate"] ?? '';
$amount = $_POST["amount"] ?? [];
$shipping = $_POST["shipping"] ?? '';
$roundoff = $_POST["roundoff"] ?? '';
$orderid = $_POST["orderid"] ?? '';
$grandtotals = $_POST["grandtotal"] ?? '';
$totaltax = $_POST["totaltax"] ?? '';
$totalsavings = $_POST["totalsavings"] ?? '';
$balance = $_POST["balance"]??'';
$paymentstatus= $_POST["paymentstatus"]??'';

// Generate new invoice number
$invoicenogeneratorquery = "SELECT invoiceno FROM invoice ORDER BY id DESC LIMIT 1";   
$invoicenogeneratorexecute = mysqli_query($connection, $invoicenogeneratorquery);

if (!$invoicenogeneratorexecute) {
    die('Error fetching invoice number: ' . mysqli_error($connection));
}

$invoicenofetch = mysqli_fetch_array($invoicenogeneratorexecute);
$invoiceno = $invoicenofetch['invoiceno'] ?? 'INV-00001';

if ($invoiceno !== "") {
    $arr = explode("-", $invoiceno);
    $value = (int)$arr[1] + 1;
    $invoiceno = 'INV-' . str_pad($value, 5, "0", STR_PAD_LEFT);
}

// Insert into invoice table
$sql = "INSERT INTO invoice (invoiceno, balance, invoicedate, duedate, customerid, grandtotal, shipping, roundoff, totaltax, totalsavings, orderid, paymentstatus) 
        VALUES ('$invoiceno','$balance', '$invoicedate', '$duedate', '$customerid', '$grandtotals', '$shipping', '$roundoff', '$totaltax', '$totalsavings', '$orderid', '$paymentstatus')";
$queryexecute = mysqli_query($connection, $sql);

if (!$queryexecute) {
    die('Error inserting invoice: ' . mysqli_error($connection));
}

$lastInsertID = mysqli_insert_id($connection);

// Insert into invoicedata table
for ($count = 0; $count < count($productid); $count++) {
    $item_name_clean = mysqli_real_escape_string($connection, $productid[$count]);
    $mrp_clean = mysqli_real_escape_string($connection, $mrp[$count]);
    $qty_clean = mysqli_real_escape_string($connection, $qty[$count]);
    $price_clean = mysqli_real_escape_string($connection, $price[$count]);
    $discountvalue_clean = mysqli_real_escape_string($connection, $discountvalue[$count]);
    $discountpercentage_clean = mysqli_real_escape_string($connection, rtrim($discountpercentage[$count], '%')); // Remove '%' from discountpercentage if it's included
    $taxpercentage_clean = mysqli_real_escape_string($connection, $taxpercentage[$count]);
    $taxvalue_clean = !empty($taxpercentage_clean) ? ($price_clean * $taxpercentage_clean / 100) : '0.00';
    $amount_clean = mysqli_real_escape_string($connection, $amount[$count]);

    $sql = "INSERT INTO invoicedata (invoiceid, productid, mrp, qty, price, discountvalue, discountpercentage, taxvalue, taxpercentage, amount) 
            VALUES ('$lastInsertID', '$item_name_clean', '$mrp_clean', '$qty_clean', '$price_clean', '$discountvalue_clean', '$discountpercentage_clean', '$taxvalue_clean', '$taxpercentage_clean', '$amount_clean')";
    $queryexecute = mysqli_query($connection, $sql);

    if (!$queryexecute) {
        die('Error inserting invoicedata: ' . mysqli_error($connection));
    }
}

// Output the last inserted ID for debugging
echo $lastInsertID;

if ($lastInsertID) {
    // Fetch profile information
    $querys = mysqli_query($connection, "SELECT * FROM profile");
    if (!$querys) {
        die('Error fetching profile data: ' . mysqli_error($connection));
    }
    $profileselect = mysqli_fetch_array($querys);

    // Assign profile data to variables with default values
    $storename = $profileselect['storename'] ?? 'Default Store Name';
    $email = $profileselect['email'] ?? 'no-reply@example.com'; 
    $street1 = $profileselect['street1'] ?? '';
    $street2 = $profileselect['street2']??'';
    $city = $profileselect['city'] ?? '';
    $state = $profileselect['state'] ?? '';
    $pincode = $profileselect['pincode'] ?? '';
    $phonenumber = $profileselect['phonenumber'] ?? '';
    $gstno = $profileselect['gstnumber'] ?? '';
    $logopath = $profileselect['logopath'] ?? '';
    $notes = $profileselect['notes'] ?? '';
    $accountno = $profileselect['account'] ?? '';
    $ifsc = $profileselect['ifsc'] ?? '';
    $bank = $profileselect['bankname'] ?? '';
    $upiid = $profileselect['upiid'] ?? '';

    // Fetch invoice information
    $query = mysqli_query($connection, "SELECT i.id, i.invoiceno, i.invoicedate, i.grandtotal, c.displayname, c.phoneno, c.address, c.city, c.pincode, c.gstno, c.email, i.orderid, i.customerid
                                        FROM invoice i 
                                        INNER JOIN customer c ON c.id = i.customerid 
                                        WHERE i.id = '$lastInsertID'");
    if (!$query) {
        die('Error fetching invoice data: ' . mysqli_error($connection));
    }
    $invoice = mysqli_fetch_array($query);
    $grandtotal1 = $invoice['grandtotal'];

    // Fetch invoice settings
    $query1 = mysqli_query($connection, "SELECT * FROM invoicesetting WHERE 1");
    if (!$query1) {
        die('Error fetching invoice settings: ' . mysqli_error($connection));
    }
    $terms = mysqli_fetch_array($query1);

    // Fetch order information
    $orderid = $invoice['orderid'];
    $orderinvoice = "SELECT orderid FROM orders WHERE id='$orderid'";
    $orderquery = mysqli_query($connection, $orderinvoice);
    if (!$orderquery) {
        die('Error fetching order data: ' . mysqli_error($connection));
    }
    $oderfetch = mysqli_fetch_array($orderquery);
    $orderid = $oderfetch['orderid'] ?? '';

    // Fetch invoice data
    $sqls = "SELECT * FROM invoicedata WHERE invoiceid ='$lastInsertID'";
    $sqlexecutes = mysqli_query($connection, $sqls);

    // Prepare for PDF details insertion
    $sqlInsert = "INSERT INTO invoicepdfdetails 
        (invoiceno,invoiceid, invoicedate, customerid,totalsavings, grandtotal, storename, email, street1,street2, city, state, pincode, phonenumber, gstnumber, logopath, notes, account, ifsc, bankname, displayname, phoneno, address, customer_city, customer_pincode, customer_gstno, customer_email,upiid, terms, qrcode) 
        VALUES 
        ('$invoiceno', '$lastInsertID', '$invoicedate', '$customerid','$totalsavings','$grandtotal1', '$storename', '$email', '$street1','$street2', '$city', '$state', '$pincode', '$phonenumber', '$gstno', '$logopath', '$notes', '$accountno', '$ifsc', '$bank', '".$invoice['displayname']."', '".$invoice['phoneno']."', '".$invoice['address']."', '".$invoice['city']."', '".$invoice['pincode']."', '".$invoice['gstno']."', '".$invoice['email']."','$upiid', '".$terms['terms']."', '".$terms['qrcode']."')";

    if (!mysqli_query($connection, $sqlInsert)) {
        die('Error inserting invoice PDF details: ' . mysqli_error($connection));
    } else {
        echo "Data inserted successfully!";
    }
} else {
    echo "Error: No invoice ID provided.";
}
?>
